document.addEventListener('DOMContentLoaded', () => {
	const cartBtnCounter = document.getElementById('cart-counter');

	const saveCart = (cart) => {
		localStorage.setItem('cart', JSON.stringify(cart));
		updateCartCounter(cart);
	};

	const loadCart = () => {
		return JSON.parse(localStorage.getItem('cart')) || [];
	};

	const updateCartCounter = (cart) => {
		const total = cart.reduce((sum, item) => sum + item.quantity, 0);
		cartBtnCounter.textContent = total;
	};

	const createQuantityControls = (productElem, product) => {
		const quantityWrapper = document.createElement('div');
		quantityWrapper.classList.add('quantity-controls');

		const minusBtn = document.createElement('button');
		minusBtn.textContent = '−';
		const plusBtn = document.createElement('button');
		plusBtn.textContent = '+';
		const quantitySpan = document.createElement('span');
		quantitySpan.textContent = product.quantity;

		quantityWrapper.append(minusBtn, quantitySpan, plusBtn);
		productElem.appendChild(quantityWrapper);

		minusBtn.addEventListener('click', () => {
			const cart = loadCart();
			const index = cart.findIndex(item => item.positionId === product.positionId);
			if (index > -1) {
				cart[index].quantity -= 1;
				cart[index].amount = cart[index].quantity * cart[index].price;
				if (cart[index].quantity <= 0) {
					cart.splice(index, 1);
					quantityWrapper.remove();
					productElem.querySelector('.add-to-cart').style.display = 'inline-block';
				} else {
					quantitySpan.textContent = cart[index].quantity;
				}
				saveCart(cart);
			}
		});

		plusBtn.addEventListener('click', () => {
			const cart = loadCart();
			const index = cart.findIndex(item => item.positionId === product.positionId);
			if (index > -1) {
				cart[index].quantity += 1;
				cart[index].amount = cart[index].quantity * cart[index].price;
				quantitySpan.textContent = cart[index].quantity;
				saveCart(cart);
			}
		});
	};

	document.querySelectorAll('.add-to-cart').forEach((btn, index) => {
		btn.addEventListener('click', () => {
			const productElem = btn.closest('.product');
			const product = {
				positionId: Number(productElem.dataset.id) ?? index+1,
				name: String(productElem.dataset.name),
				...(productElem.dataset.code && { code: String(productElem.dataset.code) }),
				...(productElem.dataset.description && { description: String(productElem.dataset.description) }),
				...(productElem.dataset.shippable && { shippable: JSON.parse(productElem.dataset.shippable) }),
				price: Number(productElem.dataset.price),
				measure: Number(productElem.dataset.measure) ?? defoultValueWidget.measure,
				quantity: 1,
				taxParams: { 
				taxType: productElem.dataset.taxtype ?? defoultValueWidget.taxType ?? 'none',
				...(productElem.dataset.taxsum && { taxSum: Number(productElem.dataset.taxsum) }),
				},
				...((productElem.dataset.paymenttype || defoultValueWidget.paymentType) && { paymentType: productElem.dataset.paymenttype ?? defoultValueWidget.paymentType }),
				...((productElem.dataset.paymentsubject || defoultValueWidget.paymentSubject) && { paymentSubject: productElem.dataset.paymentsubject ?? defoultValueWidget.paymentSubject }),
				amount: Number(productElem.dataset.price),
				...(productElem.dataset.discount && { discount: Number(productElem.dataset.discount) }),
				...(productElem.dataset.userdata && { userData: productElem.dataset.userData }),
				...(productElem.dataset.mass && { mass: productElem.dataset.mass }),
				image: productElem.querySelector('img').src,
			};

			let cart = loadCart();
			const exists = cart.find(item => item.positionId === product.positionId);
			if (!exists) {
				cart.push(product);
				saveCart(cart);
				btn.style.display = 'none';
				createQuantityControls(productElem, product);
			}
		});
	});

	// при загрузке страницы показать кнопки + - если товар уже был в корзине
	const cart = loadCart();
	cart.forEach(product => {
		const productElem = document.querySelector(`.product[data-id="${product.positionId}"]`);
		if (productElem) {
			productElem.querySelector('.add-to-cart').style.display = 'none';
			createQuantityControls(productElem, product);
		}
	});

	updateCartCounter(cart);
});